#!/bin/bash
set -e # exit on error
DATASET="vizwiz_val_short_prompt"
MODEL_PATH=$1

bash scripts/v1_5/eval/vizwiz_val.sh $MODEL_PATH 

pred_data=$(python llava/eval/utils.py check_output_file_exists --output_file ${MODEL_PATH}/${DATASET}/merge.jsonl)

echo "pred_data: ${pred_data}"
question_file=/<DATA_FOLDER>/vizwiz/val.llava_eval.short_prompt.jsonl
image_folder="<DATA_FOLDER>/vizwiz/images/val"

MODEL_PATH_LOWER=$(echo "$MODEL_PATH" | tr '[:upper:]' '[:lower:]')
if [[ $MODEL_PATH_LOWER == *"qwen-vl"* ]]; then
    echo "qwen-vl in model path"

else
    echo "skip"
fi


python llava/eval/lave_metric.py  run_lave_metric \
      --gt_data ${question_file} \
      --model_id /models/Mistral/Mistral-7B-Instruct-v0.2 \
      --pred_data ${pred_data}  